/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

//	MakeEqualLength.cpp

#include <stdafx.h>

#include "CUtility.h"
#include "CConstraints.h"
#include "CApplication.h"


HRESULT MakeEqualLength(ISet *objSet)
{

	//	Applies the EqualLength constraint on the set of given lines

	START_METHOD("MakeEqualLength")

	HRESULT status = CONV_SUCCESS;

	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *activeWorkplane = NULL;
	ISketch *activeSketch = NULL;

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	ISet *objectSet2 = NULL;

	// Create another object set

	status = (GetCLASS(ObjectSet))->CreateAObjectSet(&objectSet2);
	CHECK_RETURN_STATUS(status)

	// Get any member of the objSet
	IDispatch *object = NULL;
	status = objSet->GetAnyMember(&object);
	CHECK_RETURN_STATUS(status)

	// Get the parent workplane of the object
	IObject *pDispObject = NULL;
	status = CAST(IObject, object)->GetParent(GetBSTR("Workplane"), &pDispObject);
	CHECK_RETURN_STATUS(status)

	IWorkplane *parentWorkplane = CAST(IWorkplane, pDispObject);

	// Get the first object of objSet
	IIt *pObjectIt = NULL;
	status = (GetCLASS(It))->CreateAObjectIt(objSet,&pObjectIt);
	CHECK_RETURN_STATUS(status)

	IDispatch *pDispObj = NULL;
	status = pObjectIt->start(&pDispObj);
	CHECK_RETURN_STATUS(status)

	// Add the object to objectset2
	status = objectSet2->AddMember(pDispObj);
	CHECK_RETURN_STATUS(status)

	long noOfObjects1 = 0;
	long noOfObjects2 = 0;

	long index1 = 0;
	long index2 = 0;

	//Get the number of objects in objSet ( to iterate through the set )
	status = objSet->GetCount(&noOfObjects1);
	CHECK_RETURN_STATUS(status)

	IDispatch *line1 = NULL;
	pObjectIt->Next(&line1); 
	while (line1) {

		//Get the number of objects in objSet ( to iterate through the set )
		status = objectSet2->GetCount(&noOfObjects2);
		CHECK_RETURN_STATUS(status)

		IIt *pObjectIt2 = NULL;
		status = (GetCLASS(It))->CreateAObjectIt(objectSet2,&pObjectIt2);
		CHECK_RETURN_STATUS(status)

		IDispatch *line2 = NULL;
		pObjectIt2->start(&line2);
		while (line2) {

			// Get the index2-th object of objectSet2
			IEqualLength *pEqualLength = NULL;
			status = (GetCLASS(EqualLength))->CreateEqualLength(CAST(ILine, line1), CAST(ILine, line2), &pEqualLength);
			CHECK_RETURN_STATUS(status)

			IConstraint *constraint1 = NULL;

			status = parentWorkplane->GetConstraint(CAST(IGeomConstraint, pEqualLength), &constraint1);
			CHECK_RETURN_STATUS(status)

			if(constraint1) {
				pEqualLength->Release();

			}
			else {
					IConstraint	*pConstraint = NULL;
					status = activeWorkplane->CreateConstraint(CAST(IGeomConstraint, pEqualLength), &pConstraint);
					CHECK_RETURN_STATUS(status)
			}
			
		line2 = NULL;
		pObjectIt2->Next(&line2);
		}

		// Add the object to objectset2
		status = objectSet2->AddMember(line1);
		CHECK_RETURN_STATUS(status)

	line1 = NULL;
	pObjectIt->Next(&line1);
	}

	END_METHOD("MakeEqualLength")
}
